namespace org.owasp.appsensor.filters
{
    using System;
    using System.Web;
    using org.owasp.appsensor;

    /**
     * This class is a servlet filter that can be configured in the web.xml to 
     * provide default handling of blocking requests that are managed by 
     * AppSensor.  
     * The configuration in web.xml should be setup like this.
     * 
     * <filter>
     *    	<filter-name>AppSensorRequestBlockingFilter</filter-name>
     *    	<filter-class>
     *			org.owasp.appsensor.filters.AppSensorRequestBlockingFilter
     *		</filter-class>
     *    	<init-param>
     *     		<param-name>redirectURL</param-name>
     *     		<param-value>/errors/requestBlocked.jsp</param-value>
     *    	</init-param>
     * 	</filter>
     * 	<filter-mapping>
     *	    <filter-name>AppSensorRequestBlockingFilter</filter-name>
     *	    <url-pattern>/*</url-pattern>
     * 	</filter-mapping>
     * 
     * The "time" will be sent as a long to your configured page, and you can
     * then display this as you see fit
     */
    public class AppSensorRequestBlockingFilter : IHttpModule
    {

        private String redirectURL = "AppsensorLocked.aspx";

        public void Dispose()
        {
        }

        public void Init(HttpApplication context)
        {
            this.redirectURL = AppSensorSecurityConfiguration.GetInstance().RedirectUrl;
            HttpRequest request = context.Request;
            HttpResponse response = context.Response;

            String requestURI = request.Url.ToString();

            //set on thread local so it's accessible later
            AppSensorServiceController.setCurrentRequestURI(requestURI);

            // is page disabled or active?
            bool isActive = AppSensorServiceController.IsServiceActive(requestURI);
            if (!(isActive))
            {
                var reactivation = AppSensorServiceController.GetServiceReactivationTime(requestURI, APPSENSOR.AsUtilities.CurrentUser);
                response.Redirect(redirectURL + "?time=" + reactivation);
                // important: can't add chain.dofilter here. else, blocking by appsensor is negated
                HttpContext.Current.ApplicationInstance.CompleteRequest();
                response.End();
            }
        }
    }
}